/*
Navicat MySQL Data Transfer

Source Server         : 192.168.0.173mysql
Source Server Version : 50643
Source Host           : 192.168.0.173:3306
Source Database       : peixun382show

Target Server Type    : MYSQL
Target Server Version : 50643
File Encoding         : 65001

Date: 2019-05-22 14:20:31
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for mta_activity
-- ----------------------------
DROP TABLE IF EXISTS `mta_activity`;
CREATE TABLE `mta_activity` (
  `activityId` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(1000) DEFAULT NULL COMMENT '名称',
  `content` text COMMENT '内容(json)',
  `des` text COMMENT '描述',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除 0未删除 1删除',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`activityId`)
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_activity
-- ----------------------------

-- ----------------------------
-- Table structure for mta_askanswer
-- ----------------------------
DROP TABLE IF EXISTS `mta_askanswer`;
CREATE TABLE `mta_askanswer` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '问答ID',
  `courseId` int(10) DEFAULT NULL COMMENT '课程ID',
  `title` varchar(30) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `upid` int(10) DEFAULT NULL COMMENT '提问id',
  `approve` int(1) DEFAULT NULL COMMENT '采纳(0：未采纳,1采纳)',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `insUser` varchar(50) DEFAULT NULL COMMENT '问答人',
  `insDate` datetime DEFAULT NULL COMMENT '问答时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_askanswer
-- ----------------------------

-- ----------------------------
-- Table structure for mta_base_config
-- ----------------------------
DROP TABLE IF EXISTS `mta_base_config`;
CREATE TABLE `mta_base_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `flag` tinyint(1) DEFAULT NULL COMMENT '启用标志',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_base_config
-- ----------------------------
INSERT INTO `mta_base_config` VALUES ('1', '用户是否先看到系统首页', '0', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('8', '考试添加后自动通过审核', '1', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('2', '用户是否可以注册', '1', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('9', '课程添加后自动通过审核', '1', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('6', '注册是否需要邮箱验证', '0', 'admin', '2016-02-29 09:24:11');
INSERT INTO `mta_base_config` VALUES ('10', '用户组分类是否可以重名', '1', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('4', '首次登录系统是否修改密码', '1', 'admin', '2015-08-27 17:46:26');
INSERT INTO `mta_base_config` VALUES ('5', '注册是否需要手机验证', '0', 'admin', '2016-02-29 09:24:11');
INSERT INTO `mta_base_config` VALUES ('3', '注册后自动通过审核', '1', 'admin', '2018-08-27 09:50:30');
INSERT INTO `mta_base_config` VALUES ('7', '试卷添加后自动通过审核', '1', 'admin', '2018-08-27 09:50:30');

-- ----------------------------
-- Table structure for mta_certificates
-- ----------------------------
DROP TABLE IF EXISTS `mta_certificates`;
CREATE TABLE `mta_certificates` (
  `certId` int(10) NOT NULL AUTO_INCREMENT COMMENT '证书ID',
  `name` varchar(30) DEFAULT NULL COMMENT '证书名称',
  `number` varchar(30) DEFAULT NULL COMMENT '证书编号',
  `issueAgency` varchar(50) DEFAULT NULL COMMENT '证书发放机构',
  `issueDate` date DEFAULT NULL COMMENT '证书发放日期',
  `category` varchar(50) DEFAULT NULL COMMENT '证书类别',
  `expiryDate` varchar(20) DEFAULT NULL COMMENT '证书有效期(月)',
  `des` varchar(255) DEFAULT NULL COMMENT '证书描述',
  `pic` varchar(255) DEFAULT NULL COMMENT '证书图',
  `insUser` varchar(50) DEFAULT NULL COMMENT '创建者',
  `insDate` datetime DEFAULT NULL COMMENT '创建时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`certId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_certificates
-- ----------------------------

-- ----------------------------
-- Table structure for mta_certificates_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_certificates_user`;
CREATE TABLE `mta_certificates_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `certId` int(10) DEFAULT NULL COMMENT '证书ID',
  `expiryDate` datetime DEFAULT NULL COMMENT '证书获得日期',
  `courseId` int(10) DEFAULT NULL COMMENT '来源课程id',
  `ksid` int(10) DEFAULT NULL COMMENT '来源考试id',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_certificates_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course
-- ----------------------------
DROP TABLE IF EXISTS `mta_course`;
CREATE TABLE `mta_course` (
  `courseId` int(10) NOT NULL AUTO_INCREMENT COMMENT '课程id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `classifyId` int(10) DEFAULT NULL COMMENT '课程分类id',
  `des` longtext COMMENT '描述',
  `pic` varchar(255) DEFAULT NULL COMMENT '课程封面',
  `credit` int(10) DEFAULT '0' COMMENT '课程学分',
  `period` decimal(10,2) DEFAULT NULL COMMENT '课程学时',
  `beginTm` datetime DEFAULT NULL COMMENT '课程开始时间',
  `endTm` datetime DEFAULT NULL COMMENT '课程结束时间',
  `lecturerId` int(10) DEFAULT NULL COMMENT '讲师id',
  `passCondition` tinyint(4) DEFAULT NULL COMMENT '通过条件(0:达到学时，1:通过考试)',
  `modifyProgress` tinyint(2) DEFAULT NULL COMMENT '允许拖动播放进度(0:允许拖动播放进度，1：禁止拖动播放进度)',
  `publicClass` tinyint(1) DEFAULT '0' COMMENT '是否公共课：0公共课，1不是公共课',
  `coursewareCount` int(10) DEFAULT NULL,
  `coursewareJson` text COMMENT '课件(json)',
  `kaoshiJson` text COMMENT '考试(json)',
  `courseAccessoriesJson` text COMMENT '附件(json)',
  `certJson` text COMMENT '证书(json)',
  `review` tinyint(1) DEFAULT NULL COMMENT '审核状态',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  `shitiDisplayFlg` char(1) DEFAULT '0' COMMENT '显示试题标志位0：不显示1：显示',
  `phoneFlag` tinyint(1) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`courseId`)
) ENGINE=InnoDB AUTO_INCREMENT=410 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course
-- ----------------------------

-- ----------------------------
-- Table structure for mta_courseaccessories
-- ----------------------------
DROP TABLE IF EXISTS `mta_courseaccessories`;
CREATE TABLE `mta_courseaccessories` (
  `courseAccessoriesId` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `classifyId` int(10) DEFAULT NULL COMMENT '分类ID',
  `content` text COMMENT '内容(json)',
  `address` varchar(50) DEFAULT NULL COMMENT '地址',
  `des` text COMMENT '简介',
  `size` varchar(20) DEFAULT NULL COMMENT '大小',
  `type` int(1) DEFAULT NULL COMMENT '类型',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`courseAccessoriesId`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_courseaccessories
-- ----------------------------

-- ----------------------------
-- Table structure for mta_courseaccessories_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_courseaccessories_classify`;
CREATE TABLE `mta_courseaccessories_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '课件分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` tinyint(3) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '添加用户id',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_courseaccessories_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_courseware
-- ----------------------------
DROP TABLE IF EXISTS `mta_courseware`;
CREATE TABLE `mta_courseware` (
  `coursewareId` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(40) DEFAULT NULL COMMENT '名称',
  `classifyId` int(10) DEFAULT NULL COMMENT '分类ID',
  `content` text COMMENT '内容(json)',
  `address` varchar(250) DEFAULT NULL COMMENT '地址',
  `des` text COMMENT '描述',
  `size` varchar(20) DEFAULT NULL COMMENT '大小',
  `type` int(1) DEFAULT NULL COMMENT '类型',
  `timeLength` decimal(10,2) DEFAULT NULL COMMENT '时长(分)',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除 0未删除 1删除',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`coursewareId`)
) ENGINE=InnoDB AUTO_INCREMENT=447 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_courseware
-- ----------------------------

-- ----------------------------
-- Table structure for mta_courseware_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_courseware_classify`;
CREATE TABLE `mta_courseware_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '课件分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` tinyint(3) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '添加用户id',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_courseware_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_courseware_shiti_ts
-- ----------------------------
DROP TABLE IF EXISTS `mta_courseware_shiti_ts`;
CREATE TABLE `mta_courseware_shiti_ts` (
  `coursewareId` int(10) NOT NULL COMMENT '课件id',
  `shitiId` int(10) NOT NULL COMMENT '试题id',
  `minuteBegin` int(10) NOT NULL COMMENT '在第几分钟弹出试题',
  `shitiJson` longtext NOT NULL COMMENT '试题JSON'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_courseware_shiti_ts
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_appraise
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_appraise`;
CREATE TABLE `mta_course_appraise` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `courseId` int(10) DEFAULT NULL COMMENT '关联课程',
  `userId` int(10) DEFAULT NULL COMMENT '评价者',
  `appraise` int(1) DEFAULT NULL COMMENT '评价(1好评，0中评,-1差评)',
  `content` text COMMENT '评价内容',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `insDate` datetime DEFAULT NULL COMMENT '评价时间',
  `interpretation` varchar(255) DEFAULT NULL COMMENT '我要解释',
  `interpretationDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_appraise
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_classify`;
CREATE TABLE `mta_course_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '课件分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` tinyint(3) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '添加用户id',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_live_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_live_classify`;
CREATE TABLE `mta_course_live_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '直播课程分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` tinyint(3) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_live_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_live_collection
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_live_collection`;
CREATE TABLE `mta_course_live_collection` (
  `userid` int(10) DEFAULT NULL,
  `liveid` int(10) DEFAULT NULL,
  `insdate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_course_live_collection
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_note
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_note`;
CREATE TABLE `mta_course_note` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `courseId` int(10) DEFAULT NULL COMMENT '关联课程',
  `userId` int(10) DEFAULT NULL COMMENT '评价者',
  `title` varchar(100) DEFAULT NULL COMMENT '记录章节课件名播放时间',
  `content` longtext COMMENT '记录内容',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `insDate` datetime DEFAULT NULL COMMENT '记录时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_note
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_order
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_order`;
CREATE TABLE `mta_course_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `courseId` int(10) DEFAULT NULL COMMENT '课程id',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `orderPrice` int(10) DEFAULT NULL COMMENT '订单价格',
  `orderTm` datetime DEFAULT NULL COMMENT '下单时间',
  `orderStatus` int(10) DEFAULT NULL COMMENT '订单状态(0:未付款，1:已付款，2:学习中，3:待评价，4:已评价，5:退款中，6:已关闭)',
  `startTm` datetime DEFAULT NULL COMMENT '开始学习时间',
  `endTm` datetime DEFAULT NULL COMMENT '结束学习时间',
  `startExamTm` datetime DEFAULT NULL COMMENT '考试开始时间',
  `endExamTm` datetime DEFAULT NULL COMMENT '考试结束时间',
  `examTimes` int(11) DEFAULT '0' COMMENT '考试次数',
  `d_xtmix` text COMMENT '随机试题',
  `sorce` decimal(4,1) DEFAULT '0.0' COMMENT '所得学分',
  `daandata` text COMMENT '固定试题答案json串',
  `rdaandata` text COMMENT '固定试题答案json串',
  `state` tinyint(4) DEFAULT NULL COMMENT '0 未学习 1 已学完 ;2 学习中 ;3：已考试;4:已及格；5考试中',
  `studyProgres` text COMMENT '学习进度数据(json)',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11574 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_order
-- ----------------------------

-- ----------------------------
-- Table structure for mta_course_today_live
-- ----------------------------
DROP TABLE IF EXISTS `mta_course_today_live`;
CREATE TABLE `mta_course_today_live` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '课程id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `url` text COMMENT '课程地址',
  `pic` varchar(255) DEFAULT NULL COMMENT '课程封面',
  `activeId` varchar(255) DEFAULT NULL COMMENT '房间号',
  `classId` int(10) DEFAULT NULL COMMENT '所属课程',
  `des` longtext COMMENT '介绍',
  `lecturerId` int(10) DEFAULT NULL COMMENT '讲师id',
  `slecturerId` int(10) DEFAULT NULL COMMENT '助教id',
  `liveDate` date DEFAULT NULL COMMENT '直播日期',
  `endDate` date DEFAULT NULL COMMENT '结束日期',
  `price` decimal(10,2) DEFAULT NULL COMMENT '价格',
  `beginTm` time DEFAULT NULL COMMENT '课程开始时间',
  `endTm` time DEFAULT NULL COMMENT '课程结束时间',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  `column1` longtext,
  `column2` longtext,
  `column3` longtext,
  `column4` varchar(255) DEFAULT NULL,
  `column5` varchar(255) DEFAULT NULL,
  `column6` varchar(255) DEFAULT NULL,
  `column7` varchar(255) DEFAULT NULL,
  `column8` varchar(255) DEFAULT NULL,
  `column9` varchar(255) DEFAULT NULL,
  `column10` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_course_today_live
-- ----------------------------

-- ----------------------------
-- Table structure for mta_email_outbox
-- ----------------------------
DROP TABLE IF EXISTS `mta_email_outbox`;
CREATE TABLE `mta_email_outbox` (
  `index` int(10) NOT NULL AUTO_INCREMENT,
  `EmailTitle` varchar(255) DEFAULT NULL COMMENT '邮件主题',
  `EmailContent` longtext,
  `ToUser` varchar(255) DEFAULT NULL,
  `fromUser` int(10) DEFAULT NULL,
  `createDate` datetime DEFAULT NULL,
  PRIMARY KEY (`index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_email_outbox
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_daily_practice
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_daily_practice`;
CREATE TABLE `mta_exam_daily_practice` (
  `dailyid` int(10) NOT NULL AUTO_INCREMENT COMMENT '考试id',
  `name` varchar(30) DEFAULT NULL COMMENT '考试名称',
  `totalTm` int(10) DEFAULT NULL COMMENT '答卷时长',
  `userSignupFlg` tinyint(4) DEFAULT NULL COMMENT '是否是公共练习，1是，0否',
  `groupId` varchar(1000) DEFAULT NULL COMMENT '用户组id序列',
  `sjid` int(10) DEFAULT NULL COMMENT '试卷ID',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`dailyid`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_daily_practice
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_daily_practice_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_daily_practice_user`;
CREATE TABLE `mta_exam_daily_practice_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `dailyid` int(10) DEFAULT NULL COMMENT '考试id',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `dailyDate` date DEFAULT NULL COMMENT '练习日',
  `times` int(10) DEFAULT '0' COMMENT '练习次数',
  `endTm` datetime DEFAULT NULL COMMENT '结束考试时间',
  `sorce` decimal(6,2) DEFAULT '0.00' COMMENT '得分',
  `d_xtmix` longtext,
  `daandata` longtext,
  `rdaandata` longtext,
  `fendata` longtext,
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `ksid` (`dailyid`) USING BTREE,
  KEY `userId` (`userId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2628 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_daily_practice_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_exercise
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_exercise`;
CREATE TABLE `mta_exam_exercise` (
  `exid` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `exclassifyid` int(10) DEFAULT NULL COMMENT '练习分类id',
  `name` varchar(30) DEFAULT NULL COMMENT '名称',
  `des` varchar(255) DEFAULT NULL COMMENT '描述',
  `sjid` int(10) DEFAULT NULL COMMENT '试卷id',
  `pageSize` int(10) DEFAULT NULL COMMENT '每页题数',
  `beginTm` datetime DEFAULT NULL COMMENT '练习作业开始时间',
  `endTm` datetime DEFAULT NULL COMMENT '练习作业结束时间',
  `totalTm` int(10) DEFAULT NULL COMMENT '答卷时长',
  `resultPublishTime` datetime DEFAULT NULL COMMENT '结果发布时间,"1970-01-01 00:00:00"为交卷后立刻发布,"2099-12-31 00:00:00"永不发布',
  `publishAnswerFlg` tinyint(4) DEFAULT NULL COMMENT '是否允许考生查看答案(1:是;0:否;)',
  `examManual` tinyint(4) DEFAULT NULL COMMENT '是否需要人工评卷,0=不需要,1=需要',
  `pic` varchar(255) DEFAULT NULL COMMENT '练习作业封面',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`exid`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_exercise
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_exercise_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_exercise_classify`;
CREATE TABLE `mta_exam_exercise_classify` (
  `exClassifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '练习分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`exClassifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_exercise_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_exercise_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_exercise_user`;
CREATE TABLE `mta_exam_exercise_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `exid` int(10) DEFAULT NULL COMMENT '练习作业id',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `times` int(10) DEFAULT '0' COMMENT '练习次数',
  `startTm` datetime DEFAULT NULL COMMENT '开始练习时间',
  `endTm` datetime DEFAULT NULL COMMENT '结束练习时间',
  `sorce` int(10) DEFAULT '0' COMMENT '得分',
  `state` tinyint(4) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `daandata` text COMMENT '答案数据(json)',
  `rdaandata` text COMMENT '随机答案数据(json)',
  `fendata` text COMMENT '分值数据(json)',
  `del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=519 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_exercise_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_kaoshi
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_kaoshi`;
CREATE TABLE `mta_exam_kaoshi` (
  `ksid` int(10) NOT NULL AUTO_INCREMENT COMMENT '考试id',
  `ksClassifyId` int(10) DEFAULT NULL COMMENT '考试分类id',
  `name` varchar(30) DEFAULT NULL COMMENT '考试名称',
  `des` longtext,
  `okrate` int(10) DEFAULT NULL COMMENT '及格分数',
  `maxTimes` int(10) DEFAULT NULL COMMENT '考试次数',
  `pageSize` int(10) DEFAULT NULL COMMENT '每页题数 答卷模式 0整卷模式 1逐题模式',
  `beginTm` datetime DEFAULT NULL COMMENT '考试开始时间',
  `endTm` datetime DEFAULT NULL COMMENT '考试结束时间',
  `credit` int(10) DEFAULT NULL COMMENT '学分',
  `totalTm` int(10) DEFAULT NULL COMMENT '答卷时长',
  `userSignupFlg` tinyint(4) DEFAULT NULL COMMENT '考试需要报名 1:需要报名',
  `signUpStartTime` datetime DEFAULT NULL COMMENT '用户报名开始时间',
  `signUpEndTime` datetime DEFAULT NULL COMMENT '用户报名结束时间',
  `passingAgainFlg` tinyint(4) DEFAULT NULL COMMENT '及格后不能再考',
  `qsnRandomFlg` tinyint(4) DEFAULT NULL COMMENT '试题和选项打乱',
  `unityDuration` tinyint(4) DEFAULT NULL COMMENT '计时方式,0=以答卷开始算时,1=以考试开始时间算时',
  `disableExam` int(10) DEFAULT NULL COMMENT '禁止进入考场时间(m),0=不限制',
  `disableSubmit` int(10) DEFAULT NULL COMMENT '禁止提前交卷时间',
  `allowIp` text COMMENT '限制学习IP段,''ip1-ip2,ip3-ip4''',
  `resultPublishTime` datetime DEFAULT NULL COMMENT '考试结果发布时间,"1970-01-01 00:00:00"为永不发布',
  `publishAnswerFlg` tinyint(4) DEFAULT NULL COMMENT '是否允许考生查看答案(1:是;0:否;)',
  `isResultRank` tinyint(4) DEFAULT NULL COMMENT '是否显示排行榜,0=不显示,1=显示',
  `examManual` tinyint(4) DEFAULT NULL COMMENT '是否需要人工评卷,0=不需要,1=按人,2=按题',
  `review` tinyint(4) DEFAULT NULL COMMENT '审核状态',
  `pic` varchar(255) DEFAULT NULL COMMENT '考试封面',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  `selectFlg` char(1) DEFAULT NULL COMMENT '1:多选题少选半分 0 多选题少选不得分',
  `optionChaosFlg` char(1) DEFAULT NULL COMMENT '选项乱序标识0：正常1：乱序',
  `phoneFlag` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`ksid`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_kaoshi
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_kaoshi_cert
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_kaoshi_cert`;
CREATE TABLE `mta_exam_kaoshi_cert` (
  `ksid` int(10) NOT NULL COMMENT '考试id',
  `certId` int(10) NOT NULL COMMENT '证书ID',
  PRIMARY KEY (`ksid`,`certId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_exam_kaoshi_cert
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_kaoshi_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_kaoshi_user`;
CREATE TABLE `mta_exam_kaoshi_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `ksid` int(10) DEFAULT NULL COMMENT '考试id',
  `sjid` int(10) DEFAULT NULL,
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `signupTm` datetime DEFAULT NULL COMMENT '报名时间',
  `signupFlag` tinyint(4) DEFAULT NULL COMMENT '报名审核状态  0:审核中 1：审核通过；2：审核未通过',
  `reviewTm` datetime DEFAULT NULL COMMENT '报名通过时间',
  `times` int(10) DEFAULT '0' COMMENT '考试次数',
  `startTm` datetime DEFAULT NULL COMMENT '开始考试时间',
  `endTm` datetime DEFAULT NULL COMMENT '结束考试时间',
  `sorce` decimal(6,2) DEFAULT '0.00' COMMENT '得分',
  `state` tinyint(4) DEFAULT NULL COMMENT '考试状态,1:报名中,2:（审核通过）未考试,3:考试中,4:已交卷,5：已评分',
  `d_xtmix` longtext,
  `daandata` longtext,
  `rdaandata` longtext,
  `fendata` longtext,
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `wrongStFlag` tinyint(1) DEFAULT '0' COMMENT '是否进行错题统计',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '添加用户id',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  `examManual` tinyint(4) DEFAULT '0' COMMENT '是否需要人工评卷,0=不需要,1=需要',
  PRIMARY KEY (`id`),
  KEY `ksid` (`ksid`) USING BTREE,
  KEY `userId` (`userId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4142 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_kaoshi_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_ks_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_ks_classify`;
CREATE TABLE `mta_exam_ks_classify` (
  `sjClassifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '考试分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`sjClassifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_ks_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shijuan
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shijuan`;
CREATE TABLE `mta_exam_shijuan` (
  `sjid` int(10) NOT NULL AUTO_INCREMENT COMMENT '试卷id',
  `title` varchar(100) DEFAULT NULL COMMENT '试卷名称',
  `sjClassifyId` int(10) DEFAULT NULL COMMENT '试卷分类id',
  `des` varchar(255) DEFAULT NULL COMMENT '试卷描述',
  `d_dlmix` longtext COMMENT '固定选题(json)',
  `d_xtmix` longtext COMMENT '随机选题(json)',
  `d_shitimix` longtext COMMENT '选择试题(json)',
  `totalsorce` decimal(6,2) DEFAULT NULL COMMENT '总分',
  `totalshiti` int(10) DEFAULT NULL COMMENT '试题总数',
  `review` tinyint(1) DEFAULT NULL COMMENT '审核状态',
  `del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `insUserId` varchar(50) DEFAULT NULL COMMENT '创建人',
  `insDate` datetime DEFAULT NULL COMMENT '创建时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`sjid`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shijuan
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shijuan_kaoshi
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shijuan_kaoshi`;
CREATE TABLE `mta_exam_shijuan_kaoshi` (
  `sjid` int(10) NOT NULL COMMENT '试卷id',
  `ksid` int(10) NOT NULL COMMENT '考试id',
  PRIMARY KEY (`ksid`,`sjid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_exam_shijuan_kaoshi
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_danxuan_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_danxuan_data`;
CREATE TABLE `mta_exam_shiti_danxuan_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `xx` text COMMENT '试题选项',
  `daan` tinyint(3) DEFAULT NULL COMMENT '答案',
  `jieda` text COMMENT '解答',
  `fen` smallint(6) DEFAULT NULL COMMENT '分值',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_danxuan_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_duoxuan_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_duoxuan_data`;
CREATE TABLE `mta_exam_shiti_duoxuan_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `xx` text COMMENT '试题选项',
  `daan` varchar(255) DEFAULT NULL COMMENT '答案',
  `jieda` text COMMENT '解答',
  `fen` smallint(6) DEFAULT NULL COMMENT '分值',
  `hfen` smallint(6) DEFAULT NULL COMMENT '少选得分',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_duoxuan_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_jianda_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_jianda_data`;
CREATE TABLE `mta_exam_shiti_jianda_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `daan` text COMMENT '答案',
  `jieda` text COMMENT '解答',
  `fen` smallint(6) DEFAULT NULL COMMENT '分值',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_jianda_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_main
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_main`;
CREATE TABLE `mta_exam_shiti_main` (
  `qsnId` int(10) NOT NULL AUTO_INCREMENT COMMENT '试题id',
  `title` text COMMENT '试题题目',
  `userId` int(10) DEFAULT NULL COMMENT '添加用户id',
  `shititypeId` int(10) DEFAULT NULL COMMENT '试题类型',
  `classifyId` int(10) DEFAULT NULL COMMENT '试题分类id',
  `levelId` int(10) DEFAULT NULL COMMENT '试题级别id',
  `knowledgeId` int(10) DEFAULT NULL COMMENT '试题知识点id',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `insUser` varchar(50) DEFAULT NULL COMMENT '登录者',
  `insDate` datetime DEFAULT NULL COMMENT '登录时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB AUTO_INCREMENT=3311 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_main
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_panduan_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_panduan_data`;
CREATE TABLE `mta_exam_shiti_panduan_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `daan` tinyint(3) DEFAULT NULL COMMENT '答案',
  `jieda` text COMMENT '解答',
  `fen` smallint(6) DEFAULT NULL COMMENT '分值',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_panduan_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_tiankong_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_tiankong_data`;
CREATE TABLE `mta_exam_shiti_tiankong_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `kongs` text COMMENT '试题空',
  `jieda` text COMMENT '解答',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_tiankong_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_shiti_zuhe_data
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_shiti_zuhe_data`;
CREATE TABLE `mta_exam_shiti_zuhe_data` (
  `qsnId` int(10) NOT NULL COMMENT '试题id',
  `title` text COMMENT '试题名称',
  `jieda` text COMMENT '解答',
  `data` text COMMENT '子题目数据',
  PRIMARY KEY (`qsnId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_shiti_zuhe_data
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_sj_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_sj_classify`;
CREATE TABLE `mta_exam_sj_classify` (
  `sjClassifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '试卷分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '试卷名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`sjClassifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_sj_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_st_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_st_classify`;
CREATE TABLE `mta_exam_st_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '试题分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '试题名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_st_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_st_knowledge
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_st_knowledge`;
CREATE TABLE `mta_exam_st_knowledge` (
  `knowledgeId` int(10) NOT NULL AUTO_INCREMENT COMMENT '试题知识点id',
  `name` varchar(50) DEFAULT NULL COMMENT '知识点名称',
  `upid` int(10) DEFAULT NULL COMMENT '父知识点',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`knowledgeId`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_st_knowledge
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_st_ks_count
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_st_ks_count`;
CREATE TABLE `mta_exam_st_ks_count` (
  `ksid` int(11) DEFAULT NULL,
  `qsnid` int(11) DEFAULT NULL,
  `totalCount` int(11) DEFAULT NULL,
  UNIQUE KEY `ksid_qsnid` (`ksid`,`qsnid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_exam_st_ks_count
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_st_level
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_st_level`;
CREATE TABLE `mta_exam_st_level` (
  `levelId` int(10) NOT NULL AUTO_INCREMENT COMMENT '试题级别id',
  `name` varchar(50) DEFAULT NULL COMMENT '级别名称',
  `upid` int(10) DEFAULT NULL COMMENT '父级别',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '创建用户id',
  PRIMARY KEY (`levelId`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_st_level
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_st_type
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_st_type`;
CREATE TABLE `mta_exam_st_type` (
  `stTypeId` int(11) NOT NULL AUTO_INCREMENT COMMENT '试题类型id',
  `name` varchar(100) DEFAULT NULL COMMENT '类型名称',
  `tixing` varchar(20) DEFAULT NULL COMMENT '题型',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`stTypeId`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_st_type
-- ----------------------------
INSERT INTO `mta_exam_st_type` VALUES ('1', '单选题', 'danxuan', '1');
INSERT INTO `mta_exam_st_type` VALUES ('2', '不定项选择题', 'duoxuan', '2');
INSERT INTO `mta_exam_st_type` VALUES ('6', '阅读理解', 'zuhe', '6');
INSERT INTO `mta_exam_st_type` VALUES ('4', '填空题', 'tiankong', '4');
INSERT INTO `mta_exam_st_type` VALUES ('5', '简答题', 'jianda', '5');
INSERT INTO `mta_exam_st_type` VALUES ('3', '判断题', 'panduan', '3');

-- ----------------------------
-- Table structure for mta_exam_wrong_st
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_wrong_st`;
CREATE TABLE `mta_exam_wrong_st` (
  `ksid` int(11) DEFAULT NULL COMMENT '考试id',
  `qsnId` int(11) DEFAULT NULL COMMENT '试题id',
  `userId` int(11) DEFAULT NULL COMMENT '用户id',
  `errorTimes` int(11) DEFAULT NULL COMMENT '错误次数',
  `ksdaan` varchar(3000) DEFAULT NULL COMMENT '考生错误答案',
  UNIQUE KEY `key` (`ksid`,`qsnId`,`userId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_wrong_st
-- ----------------------------

-- ----------------------------
-- Table structure for mta_exam_wrong_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_exam_wrong_user`;
CREATE TABLE `mta_exam_wrong_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL COMMENT '用户ID',
  `ksid` int(10) NOT NULL COMMENT '考试id',
  `stids` longtext NOT NULL COMMENT '试题ID集合',
  `htids` longtext COMMENT '曾经错题id',
  `cnt` int(10) DEFAULT NULL COMMENT '错题数',
  `publishDate` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '发布时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_exam_wrong_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_lecturer
-- ----------------------------
DROP TABLE IF EXISTS `mta_lecturer`;
CREATE TABLE `mta_lecturer` (
  `lecturerId` int(10) NOT NULL AUTO_INCREMENT COMMENT '讲师id',
  `name` varchar(50) DEFAULT NULL COMMENT '讲师名',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `gender` tinyint(1) DEFAULT NULL COMMENT '性别',
  `birthday` date DEFAULT NULL COMMENT '出身年月',
  `tel` varchar(20) DEFAULT NULL COMMENT '电话',
  `level` varchar(20) DEFAULT NULL COMMENT '讲师级别',
  `briefIntroduction` varchar(255) DEFAULT NULL COMMENT '讲师简介',
  `insUser` varchar(50) DEFAULT NULL COMMENT '创建者',
  `insDate` datetime DEFAULT NULL COMMENT '创建时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`lecturerId`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_lecturer
-- ----------------------------

-- ----------------------------
-- Table structure for mta_message
-- ----------------------------
DROP TABLE IF EXISTS `mta_message`;
CREATE TABLE `mta_message` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `msgType` int(10) DEFAULT NULL COMMENT '消息分类：0：公告，1系统消息',
  `msgTitle` varchar(80) DEFAULT NULL COMMENT '消息标题',
  `msgContent` longtext COMMENT '消息内容',
  `userId` int(10) DEFAULT NULL COMMENT '用户ID',
  `sendTime` datetime DEFAULT NULL COMMENT '发送时间',
  `skipUrl` varchar(200) DEFAULT NULL COMMENT '跳转地址',
  `readMsg` smallint(4) DEFAULT '0' COMMENT '消息是否查看',
  `insUser` varchar(50) DEFAULT NULL COMMENT '发布人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_message
-- ----------------------------

-- ----------------------------
-- Table structure for mta_mobile
-- ----------------------------
DROP TABLE IF EXISTS `mta_mobile`;
CREATE TABLE `mta_mobile` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL COMMENT '名字',
  `tel` varchar(20) DEFAULT NULL COMMENT '手机号',
  `code` varchar(10) DEFAULT NULL COMMENT '验证码',
  `password` varchar(20) DEFAULT NULL COMMENT '密码',
  `flag` int(10) DEFAULT NULL COMMENT '麦塔系统0：没预定，1预定',
  `ksflag` int(10) DEFAULT NULL COMMENT '考试系统0：没预定，1预定',
  `dmoney` int(10) DEFAULT NULL COMMENT '代金券（0：没有预定，1:预定成功）',
  `mtacount` varchar(20) DEFAULT NULL COMMENT '培训随机数',
  `kscount` varchar(20) DEFAULT NULL COMMENT '考试随机码',
  `djjcount` varchar(20) DEFAULT NULL COMMENT '代金券随机码',
  `ins_date` date DEFAULT NULL COMMENT '预定时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_mobile
-- ----------------------------

-- ----------------------------
-- Table structure for mta_msg_log
-- ----------------------------
DROP TABLE IF EXISTS `mta_msg_log`;
CREATE TABLE `mta_msg_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `senderId` int(10) NOT NULL COMMENT '发送人',
  `msgContent` longtext COMMENT '消息内容',
  `recipientId` int(10) DEFAULT NULL COMMENT '收件人',
  `sendTime` datetime DEFAULT NULL COMMENT '发送时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_msg_log
-- ----------------------------

-- ----------------------------
-- Table structure for mta_position
-- ----------------------------
DROP TABLE IF EXISTS `mta_position`;
CREATE TABLE `mta_position` (
  `positionId` int(10) NOT NULL AUTO_INCREMENT COMMENT '职位id',
  `name` varchar(30) NOT NULL COMMENT '职位名',
  `des` varchar(100) NOT NULL COMMENT '职位描述',
  `sort` int(10) NOT NULL COMMENT '排序',
  `insDate` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`positionId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_position
-- ----------------------------

-- ----------------------------
-- Table structure for mta_project_log
-- ----------------------------
DROP TABLE IF EXISTS `mta_project_log`;
CREATE TABLE `mta_project_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mac` varchar(255) NOT NULL COMMENT 'mac地址',
  `operationDate` datetime DEFAULT NULL COMMENT '操作时间',
  `type` tinyint(2) DEFAULT '0' COMMENT '操作类型（1-查询，2-添加，3-更新，4-删除）',
  `moduleName` varchar(255) DEFAULT NULL COMMENT '操作模块名称',
  `stopTime` int(10) DEFAULT '0' COMMENT '停留时间（秒）',
  `username` varchar(50) DEFAULT '操作人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8717 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_project_log
-- ----------------------------
INSERT INTO `mta_project_log` VALUES ('8715', '58-FB-84-8C-39-A4', '2019-05-22 14:19:36', '1', '登录', '0', 'admin');
INSERT INTO `mta_project_log` VALUES ('8716', '58-FB-84-8C-39-A4', '2019-05-22 14:20:24', '1', '登录', '0', 'admin');

-- ----------------------------
-- Table structure for mta_resource
-- ----------------------------
DROP TABLE IF EXISTS `mta_resource`;
CREATE TABLE `mta_resource` (
  `resourceId` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(40) DEFAULT NULL COMMENT '名称',
  `classifyId` int(10) DEFAULT NULL COMMENT '分类ID',
  `content` text COMMENT '内容(json)',
  `address` varchar(250) DEFAULT NULL COMMENT '地址 :0：本地上传 1：指定路径',
  `des` text COMMENT '简介',
  `size` varchar(20) DEFAULT NULL COMMENT '大小',
  `type` int(1) DEFAULT NULL COMMENT '类型',
  `timeLength` decimal(10,2) DEFAULT NULL COMMENT '时长(分)',
  `downloads` int(10) DEFAULT '0' COMMENT '下载次数',
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读0:未阅读;1:已阅读',
  `del` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `uuid` varchar(50) DEFAULT NULL COMMENT 'uuid（前台传值用）',
  `userId` int(10) DEFAULT NULL COMMENT '用户id',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`resourceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_resource
-- ----------------------------

-- ----------------------------
-- Table structure for mta_resource_classify
-- ----------------------------
DROP TABLE IF EXISTS `mta_resource_classify`;
CREATE TABLE `mta_resource_classify` (
  `classifyId` int(10) NOT NULL AUTO_INCREMENT COMMENT '课件分类id',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `upid` int(10) DEFAULT NULL COMMENT '父分类',
  `sort` tinyint(3) DEFAULT NULL COMMENT '排序',
  `insUser` int(10) DEFAULT NULL COMMENT '添加用户id',
  PRIMARY KEY (`classifyId`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_resource_classify
-- ----------------------------

-- ----------------------------
-- Table structure for mta_resource_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_resource_user`;
CREATE TABLE `mta_resource_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) DEFAULT NULL,
  `resourceId` int(11) DEFAULT NULL,
  `insDate` datetime DEFAULT NULL,
  `readFlag` tinyint(1) DEFAULT '0' COMMENT '用户是否阅读（0未阅读1已阅读）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_resource_user
-- ----------------------------

-- ----------------------------
-- Table structure for mta_sys_constant
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_constant`;
CREATE TABLE `mta_sys_constant` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL COMMENT '键',
  `value` varchar(255) NOT NULL COMMENT '值',
  `type` varchar(255) NOT NULL COMMENT '类型',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_constant
-- ----------------------------
INSERT INTO `mta_sys_constant` VALUES ('1', 'accessKeyID', 'LTAIU5bgB80NSjhq', 'aliyun', null);
INSERT INTO `mta_sys_constant` VALUES ('2', 'accessKeySecret', 'I7X0zGCEpMvxhn0MLKkGQ0VPbeY1OP', 'aliyun', null);

-- ----------------------------
-- Table structure for mta_sys_email
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_email`;
CREATE TABLE `mta_sys_email` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userName` varchar(255) NOT NULL COMMENT '用户名',
  `password` varchar(255) NOT NULL COMMENT '密码',
  `SMTP` varchar(255) NOT NULL COMMENT 'SMTP服务器',
  `type` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_email
-- ----------------------------

-- ----------------------------
-- Table structure for mta_sys_function
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_function`;
CREATE TABLE `mta_sys_function` (
  `functionId` int(10) NOT NULL AUTO_INCREMENT COMMENT '功能id',
  `moduleId` int(10) NOT NULL COMMENT '模块id',
  `icon` varchar(30) DEFAULT NULL COMMENT '功能图标',
  `name` varchar(30) NOT NULL COMMENT '功能名称',
  `enname` varchar(255) NOT NULL COMMENT '英文名',
  `url` varchar(255) DEFAULT NULL,
  `sort` int(10) NOT NULL COMMENT '排序',
  PRIMARY KEY (`functionId`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_function
-- ----------------------------
INSERT INTO `mta_sys_function` VALUES ('24', '9', null, '发送消息', 'News Bulletin Management', 'admin/N010/saveMessage.html', '3');
INSERT INTO `mta_sys_function` VALUES ('36', '1', null, '在线用户监控', 'Online user', 'admin/U070/OnlineUserMonitoring.html', '100');
INSERT INTO `mta_sys_function` VALUES ('14', '4', null, '课程管理', 'Course Management', 'admin/C010/manageCourse.html', '1');
INSERT INTO `mta_sys_function` VALUES ('38', '8', null, '错题统计', 'Wrong Statistics', 'admin/S060/manageAllErrorTestQuestions.html', '5');
INSERT INTO `mta_sys_function` VALUES ('1', '1', null, '用户信息管理', 'User Information', 'admin/U010/manageUser.html', '3');
INSERT INTO `mta_sys_function` VALUES ('23', '9', null, '发送消息管理', 'Send Message Management', 'admin/N010/manageMessage.html', '1');
INSERT INTO `mta_sys_function` VALUES ('8', '2', null, '课程分类设置', 'Course Classification', 'admin/B020/manageStudyClassifyType.html', '2');
INSERT INTO `mta_sys_function` VALUES ('37', '11', '', '数据备份', 'Data Backup', 'admin/D010/manageDatabackup.html', '112');
INSERT INTO `mta_sys_function` VALUES ('2', '1', null, '用户批量导入', 'Batch Export Users', 'admin/U010/importUser.html', '2');
INSERT INTO `mta_sys_function` VALUES ('45', '2', null, '登入日志', 'Login log', 'admin/L080/L080dengruLog.html?type=0', '4');
INSERT INTO `mta_sys_function` VALUES ('46', '2', null, '操作日志', 'Operation log', 'admin/L080/L080dengruLog.html?type=1', '5');
INSERT INTO `mta_sys_function` VALUES ('9', '2', null, '系统参数设置', 'System Parameter', 'admin/S010/manageSystemParameter.html', '3');
INSERT INTO `mta_sys_function` VALUES ('6', '1', null, '讲师管理', 'Lecturer Management', 'admin/U050/manageLecturer.html', '6');
INSERT INTO `mta_sys_function` VALUES ('21', '8', null, '考试统计', 'Test Statistics', 'admin/S030/manageAllStatisticsExam.html', '2');
INSERT INTO `mta_sys_function` VALUES ('53', '9', null, '活动管理', 'Activity Mangemnent', 'admin/A020/manageActivity.html', '4');
INSERT INTO `mta_sys_function` VALUES ('15', '4', null, '课件管理', 'Courseware Management', 'admin/C020/manageCourseware.html', '2');
INSERT INTO `mta_sys_function` VALUES ('42', '4', null, '今日直播课程管理', 'Today Live Course', 'admin/C011/manageTodayLiveCourse.html', '6');
INSERT INTO `mta_sys_function` VALUES ('16', '4', null, '附件管理', 'Accessories Management', 'admin/C030/manageAccessories.html', '3');
INSERT INTO `mta_sys_function` VALUES ('39', '4', null, '课程监控', 'Monitoring', 'admin/S040/managerAllStatisticsCourse.html?cour=1', '4');
INSERT INTO `mta_sys_function` VALUES ('26', '2', null, '审核管理', 'Audit Management', 'admin/E010/manageAudit.html', '7');
INSERT INTO `mta_sys_function` VALUES ('13', '3', null, '考试管理', 'Test Management', 'admin/T040/examManage.html', '4');
INSERT INTO `mta_sys_function` VALUES ('44', '4', null, '课程考试成绩管理', 'Course Test Score', 'admin/C050/manageKcChengji.html', '7');
INSERT INTO `mta_sys_function` VALUES ('17', '5', null, '资源管理', 'Source Management', 'admin/R010/manageResource.html', '1');
INSERT INTO `mta_sys_function` VALUES ('10', '3', null, '试题管理', 'Question', 'admin/T010/manageQsn.html', '1');
INSERT INTO `mta_sys_function` VALUES ('12', '3', null, '试卷管理', 'Test Paper Management', 'admin/T030/manageTestPaper.html', '3');
INSERT INTO `mta_sys_function` VALUES ('27', '3', null, '考试监控', 'Test Supervision', 'admin/T050/ExamMonitor.html', '5');
INSERT INTO `mta_sys_function` VALUES ('4', '1', null, '角色管理', 'Role Management', 'admin/U040/ManageRole.html', '4');
INSERT INTO `mta_sys_function` VALUES ('20', '8', null, '用户统计', 'User Statistics', 'admin/S020/managerStatisticsUser.html', '1');
INSERT INTO `mta_sys_function` VALUES ('18', '6', null, '问答管理', 'Q&A management', 'admin/Q010/manageAskanswer.html', '1');
INSERT INTO `mta_sys_function` VALUES ('5', '1', null, '职位管理', 'Position Management', 'admin/U060/ManagePosition.html', '5');
INSERT INTO `mta_sys_function` VALUES ('11', '3', null, '批量导入试题', 'Import Questions', 'admin/T020/importQsn.html', '2');
INSERT INTO `mta_sys_function` VALUES ('28', '3', null, '人工评卷', 'Manually Grade Paper', 'admin/T060/ManageEvaluation.html', '6');
INSERT INTO `mta_sys_function` VALUES ('50', '3', null, '每日一练', 'Daily Practice', 'admin/T100/manageDailyPractice.html', '10');
INSERT INTO `mta_sys_function` VALUES ('30', '3', null, '练习作业管理', 'Paractice Management', 'admin/T080/manageEx.html', '8');
INSERT INTO `mta_sys_function` VALUES ('49', '4', null, '直播管理', 'Today Live', 'admin/C011/manageTodayLiveCourse.html', '9');
INSERT INTO `mta_sys_function` VALUES ('47', '2', null, '日志统计图', 'Log chart', 'admin/L080/logBigData.html', '6');
INSERT INTO `mta_sys_function` VALUES ('31', '3', null, '考试报名审核', 'Review of exam signing up', 'admin/T090/manageTestRegistrationReview.html', '9');
INSERT INTO `mta_sys_function` VALUES ('22', '8', null, '课程统计', 'Course Statistics', 'admin/S040/managerAllStatisticsCourse.html', '3');
INSERT INTO `mta_sys_function` VALUES ('51', '3', null, '每日一练成绩管理', 'Daily Practice Score', 'admin/T100/manageDailyPracticeResult.html', '11');
INSERT INTO `mta_sys_function` VALUES ('3', '1', null, '组织机构创建', 'Create Organization', 'admin/U030/ManageUserGroup.html', '1');
INSERT INTO `mta_sys_function` VALUES ('7', '2', null, '考试分类设置', 'Exam Classification', 'admin/B010/manageExamClassifyType.html', '1');
INSERT INTO `mta_sys_function` VALUES ('40', '8', null, '机构考试统计', 'Institutional Test Statistics', 'admin/S070/manageShowData.html', '6');
INSERT INTO `mta_sys_function` VALUES ('48', '2', null, '视频点播设置', 'Video settings', 'admin/A010/configAliAccess.html', '8');
INSERT INTO `mta_sys_function` VALUES ('33', '4', null, '评价管理', 'Evaluation', 'admin/C040/manageAppraise.html', '4');
INSERT INTO `mta_sys_function` VALUES ('41', '8', '', '机构课程统计', 'Institutional Course Statistics', 'admin/S070/manageShowCourseData.html', '7');
INSERT INTO `mta_sys_function` VALUES ('29', '3', null, '成绩管理', 'Score Management', 'admin/T070/manageExamResults.html', '7');
INSERT INTO `mta_sys_function` VALUES ('43', '9', null, '新闻公告管理', 'Send A Message', 'admin/N010/manageNews.html', '2');
INSERT INTO `mta_sys_function` VALUES ('32', '8', null, '大数据统计', 'Big Data Statistics', 'admin/S050/manageBigData.html', '4');
INSERT INTO `mta_sys_function` VALUES ('19', '7', null, '证书管理', 'Certificate', 'admin/Z010/ManageCertificate.html', '1');

-- ----------------------------
-- Table structure for mta_sys_group
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_group`;
CREATE TABLE `mta_sys_group` (
  `groupId` int(10) NOT NULL AUTO_INCREMENT COMMENT '用户组id',
  `groupPid` int(10) NOT NULL COMMENT '父用户组id',
  `groupName` varchar(50) NOT NULL COMMENT '用户组名称',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_group
-- ----------------------------

-- ----------------------------
-- Table structure for mta_sys_module
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_module`;
CREATE TABLE `mta_sys_module` (
  `moduleId` int(10) NOT NULL AUTO_INCREMENT COMMENT '模块id',
  `icon` varchar(30) DEFAULT NULL COMMENT '模块图标',
  `name` varchar(30) NOT NULL COMMENT '模块名称',
  `enname` varchar(255) NOT NULL COMMENT '英文名',
  `sort` int(10) NOT NULL COMMENT '排序',
  PRIMARY KEY (`moduleId`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_module
-- ----------------------------
INSERT INTO `mta_sys_module` VALUES ('1', 'icon-menu-user', '用户管理中心', 'User', '1');
INSERT INTO `mta_sys_module` VALUES ('8', 'icon-menu-count', '统计管理中心', 'Statistical', '8');
INSERT INTO `mta_sys_module` VALUES ('2', 'icon-menu-base', '基础数据中心', 'Basic center', '2');
INSERT INTO `mta_sys_module` VALUES ('9', 'icon-menu-news', '新闻公告中心', 'Press', '9');
INSERT INTO `mta_sys_module` VALUES ('6', 'icon-menu-answer', '问答管理中心', 'Q&A', '6');
INSERT INTO `mta_sys_module` VALUES ('4', 'icon-menu-course', '课程管理中心', 'Course', '4');
INSERT INTO `mta_sys_module` VALUES ('5', 'icon-menu-resource', '资源管理中心', 'Resource', '5');
INSERT INTO `mta_sys_module` VALUES ('11', 'icon-menu-base', '数据安全中心', 'Data Security', '11');
INSERT INTO `mta_sys_module` VALUES ('3', 'icon-menu-exam', '考试管理中心', 'Examination', '3');
INSERT INTO `mta_sys_module` VALUES ('7', 'icon-menu-cert', '证书管理中心', 'Certificate', '7');

-- ----------------------------
-- Table structure for mta_sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_permission`;
CREATE TABLE `mta_sys_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL COMMENT '名称',
  `functionId` int(10) NOT NULL COMMENT '功能id',
  `permission` varchar(100) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_permission
-- ----------------------------
INSERT INTO `mta_sys_permission` VALUES ('1', '查询', '1', 'sys:user:list', '1');
INSERT INTO `mta_sys_permission` VALUES ('2', '新建', '1', 'sys:user:save', '2');
INSERT INTO `mta_sys_permission` VALUES ('4', '删除', '1', 'sys:user:remove', '4');
INSERT INTO `mta_sys_permission` VALUES ('3', '修改', '1', 'sys:user:update', '3');

-- ----------------------------
-- Table structure for mta_sys_role
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_role`;
CREATE TABLE `mta_sys_role` (
  `roleId` int(10) NOT NULL AUTO_INCREMENT COMMENT '角色id',
  `Name` varchar(30) NOT NULL COMMENT '角色名称',
  `Des` varchar(100) NOT NULL COMMENT '描述',
  `sort` int(10) NOT NULL COMMENT '排序',
  PRIMARY KEY (`roleId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_role
-- ----------------------------
INSERT INTO `mta_sys_role` VALUES ('1', '超级管理员', '超级管理', '3');
INSERT INTO `mta_sys_role` VALUES ('2', '学员', '学生', '5');
INSERT INTO `mta_sys_role` VALUES ('5', '二级管理员', '', '6');

-- ----------------------------
-- Table structure for mta_sys_role_function
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_role_function`;
CREATE TABLE `mta_sys_role_function` (
  `roleId` int(10) NOT NULL COMMENT '角色id',
  `functionId` int(10) NOT NULL COMMENT '功能id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_sys_role_function
-- ----------------------------
INSERT INTO `mta_sys_role_function` VALUES ('1', '3');
INSERT INTO `mta_sys_role_function` VALUES ('1', '2');
INSERT INTO `mta_sys_role_function` VALUES ('1', '1');
INSERT INTO `mta_sys_role_function` VALUES ('1', '4');
INSERT INTO `mta_sys_role_function` VALUES ('1', '5');
INSERT INTO `mta_sys_role_function` VALUES ('1', '6');
INSERT INTO `mta_sys_role_function` VALUES ('1', '36');
INSERT INTO `mta_sys_role_function` VALUES ('1', '7');
INSERT INTO `mta_sys_role_function` VALUES ('1', '8');
INSERT INTO `mta_sys_role_function` VALUES ('1', '9');
INSERT INTO `mta_sys_role_function` VALUES ('1', '45');
INSERT INTO `mta_sys_role_function` VALUES ('1', '46');
INSERT INTO `mta_sys_role_function` VALUES ('1', '47');
INSERT INTO `mta_sys_role_function` VALUES ('1', '26');
INSERT INTO `mta_sys_role_function` VALUES ('1', '48');
INSERT INTO `mta_sys_role_function` VALUES ('1', '10');
INSERT INTO `mta_sys_role_function` VALUES ('1', '11');
INSERT INTO `mta_sys_role_function` VALUES ('1', '12');
INSERT INTO `mta_sys_role_function` VALUES ('1', '13');
INSERT INTO `mta_sys_role_function` VALUES ('1', '27');
INSERT INTO `mta_sys_role_function` VALUES ('1', '28');
INSERT INTO `mta_sys_role_function` VALUES ('1', '29');
INSERT INTO `mta_sys_role_function` VALUES ('1', '30');
INSERT INTO `mta_sys_role_function` VALUES ('1', '31');
INSERT INTO `mta_sys_role_function` VALUES ('1', '50');
INSERT INTO `mta_sys_role_function` VALUES ('1', '51');
INSERT INTO `mta_sys_role_function` VALUES ('1', '14');
INSERT INTO `mta_sys_role_function` VALUES ('1', '15');
INSERT INTO `mta_sys_role_function` VALUES ('1', '16');
INSERT INTO `mta_sys_role_function` VALUES ('1', '33');
INSERT INTO `mta_sys_role_function` VALUES ('1', '39');
INSERT INTO `mta_sys_role_function` VALUES ('1', '44');
INSERT INTO `mta_sys_role_function` VALUES ('1', '17');
INSERT INTO `mta_sys_role_function` VALUES ('1', '18');
INSERT INTO `mta_sys_role_function` VALUES ('1', '19');
INSERT INTO `mta_sys_role_function` VALUES ('1', '20');
INSERT INTO `mta_sys_role_function` VALUES ('1', '21');
INSERT INTO `mta_sys_role_function` VALUES ('1', '22');
INSERT INTO `mta_sys_role_function` VALUES ('1', '32');
INSERT INTO `mta_sys_role_function` VALUES ('1', '38');
INSERT INTO `mta_sys_role_function` VALUES ('1', '40');
INSERT INTO `mta_sys_role_function` VALUES ('1', '41');
INSERT INTO `mta_sys_role_function` VALUES ('1', '23');
INSERT INTO `mta_sys_role_function` VALUES ('1', '43');
INSERT INTO `mta_sys_role_function` VALUES ('1', '24');
INSERT INTO `mta_sys_role_function` VALUES ('1', '53');
INSERT INTO `mta_sys_role_function` VALUES ('1', '37');
INSERT INTO `mta_sys_role_function` VALUES ('1', '54');

-- ----------------------------
-- Table structure for mta_sys_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_role_permission`;
CREATE TABLE `mta_sys_role_permission` (
  `roleId` int(10) NOT NULL COMMENT '角色id',
  `permissionId` int(10) NOT NULL COMMENT '功能id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of mta_sys_role_permission
-- ----------------------------

-- ----------------------------
-- Table structure for mta_sys_user
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_user`;
CREATE TABLE `mta_sys_user` (
  `userId` int(10) NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `userName` varchar(50) DEFAULT NULL COMMENT '用户名',
  `roleId` int(10) DEFAULT '0' COMMENT '角色id',
  `groupId` int(10) DEFAULT NULL COMMENT '用户组id',
  `positionId` int(10) DEFAULT NULL COMMENT '职位id',
  `nickName` varchar(50) DEFAULT NULL COMMENT '昵称',
  `realName` varchar(50) DEFAULT NULL COMMENT '真实姓名',
  `pwd` varchar(50) DEFAULT NULL COMMENT '密码',
  `changePwd` tinyint(1) DEFAULT NULL COMMENT '第一次登陆后修改密码',
  `status` int(10) DEFAULT '0' COMMENT '用户状态:1禁用/0解禁',
  `review` tinyint(1) DEFAULT '0' COMMENT '注册审核状态：0未审核/1审核',
  `gender` tinyint(1) DEFAULT NULL COMMENT '性别',
  `tel` varchar(50) DEFAULT NULL COMMENT '电话',
  `telConfirm` tinyint(1) DEFAULT NULL COMMENT '电话验证',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `emailConfirm` tinyint(1) DEFAULT NULL COMMENT '邮箱验证',
  `icon` varchar(100) DEFAULT NULL COMMENT '头像',
  `birthday` date DEFAULT NULL COMMENT '出身年月',
  `credit` int(11) DEFAULT '0' COMMENT '学分',
  `point` int(11) DEFAULT '0' COMMENT '用户所得学分',
  `idcard` varchar(20) DEFAULT NULL COMMENT '身份证/QQ',
  `examcard` varchar(30) DEFAULT NULL COMMENT '考试卡',
  `loginCount` int(11) DEFAULT '0' COMMENT '登陆次数',
  `lastLoginDate` datetime DEFAULT NULL COMMENT '最后一次登陆时间',
  `lastLoginIp` varchar(50) DEFAULT NULL COMMENT '最后一次登陆ip',
  `loginFailedNum` int(11) DEFAULT '0' COMMENT '连续登入失败次数',
  `entryTime` datetime DEFAULT NULL COMMENT '用户入职时间',
  `del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `regIp` varchar(50) DEFAULT NULL COMMENT '注册ip',
  `uuid` varchar(50) DEFAULT NULL,
  `insUser` varchar(50) DEFAULT NULL COMMENT '注册者',
  `insDate` datetime DEFAULT NULL COMMENT '注册时间',
  `updUser` varchar(50) DEFAULT NULL COMMENT '更新者',
  `updDate` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=610 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_user
-- ----------------------------
INSERT INTO `mta_sys_user` VALUES ('1', 'admin', '1', '1', '11', '管理员', '管理员', 'A43AB21DC0CCD704', '1', '0', '1', '1', '13514118618', '1', '123@qq.com', '1', '/upload/uploadMta3/userHeadImage/1521164949429_162.jpg', '2015-06-25', '0', null, '121111111111111111', null, '8819', '2019-05-22 14:20:24', '192.168.0.72', '0', '2015-06-15 16:29:44', '0', '127.0.0.1', '2b52ee41-1a12-11e5-b5e8-d4ae52d18520', null, '2018-01-01 15:29:02', '1', '2019-05-22 11:30:46');

-- ----------------------------
-- Table structure for mta_sys_user_count
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_user_count`;
CREATE TABLE `mta_sys_user_count` (
  `userId` int(10) NOT NULL COMMENT '角色id',
  `type` int(10) NOT NULL COMMENT '功能id 1:课程，2：考试，3：练习',
  `cid` int(10) DEFAULT NULL COMMENT '课程，考试，练习id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户课程、考试、练习未读表';

-- ----------------------------
-- Records of mta_sys_user_count
-- ----------------------------

-- ----------------------------
-- Table structure for mta_sys_user_group
-- ----------------------------
DROP TABLE IF EXISTS `mta_sys_user_group`;
CREATE TABLE `mta_sys_user_group` (
  `userId` int(10) NOT NULL COMMENT '用户id',
  `groupId` varchar(255) NOT NULL COMMENT '用户管理的用户组id列表'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_sys_user_group
-- ----------------------------
INSERT INTO `mta_sys_user_group` VALUES ('576', '');
INSERT INTO `mta_sys_user_group` VALUES ('577', '');
INSERT INTO `mta_sys_user_group` VALUES ('578', '');
INSERT INTO `mta_sys_user_group` VALUES ('579', '');
INSERT INTO `mta_sys_user_group` VALUES ('580', '');
INSERT INTO `mta_sys_user_group` VALUES ('604', '');
INSERT INTO `mta_sys_user_group` VALUES ('605', '');
INSERT INTO `mta_sys_user_group` VALUES ('606', '');
INSERT INTO `mta_sys_user_group` VALUES ('607', '');
INSERT INTO `mta_sys_user_group` VALUES ('608', '');
INSERT INTO `mta_sys_user_group` VALUES ('609', '');

-- ----------------------------
-- Table structure for mta_worktype
-- ----------------------------
DROP TABLE IF EXISTS `mta_worktype`;
CREATE TABLE `mta_worktype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '工种id',
  `name` varchar(30) NOT NULL COMMENT '职位名',
  `des` varchar(100) NOT NULL COMMENT '职位描述',
  `sort` int(10) NOT NULL COMMENT '排序',
  `insDate` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mta_worktype
-- ----------------------------
INSERT INTO `mta_worktype` VALUES ('1', '初级建筑物消防员', '', '1', '2018-07-05 10:58:56');
INSERT INTO `mta_worktype` VALUES ('2', '中级建筑物消防员', '', '2', '2018-07-05 10:59:05');
INSERT INTO `mta_worktype` VALUES ('4', '中级构筑物消防员', ' ', '4', '2018-08-10 10:16:30');
INSERT INTO `mta_worktype` VALUES ('5', '灭火救援员', '', '5', '2018-07-05 10:59:17');
INSERT INTO `mta_worktype` VALUES ('3', '初级构筑物消防员', ' ', '3', '2018-08-10 10:16:06');

-- ----------------------------
-- Table structure for tmp_period
-- ----------------------------
DROP TABLE IF EXISTS `tmp_period`;
CREATE TABLE `tmp_period` (
  `period` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of tmp_period
-- ----------------------------

-- ----------------------------
-- Table structure for tmp_split
-- ----------------------------
DROP TABLE IF EXISTS `tmp_split`;
CREATE TABLE `tmp_split` (
  `val_` varchar(128) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of tmp_split
-- ----------------------------

-- ----------------------------
-- Table structure for tmp_table_classifyid
-- ----------------------------
DROP TABLE IF EXISTS `tmp_table_classifyid`;
CREATE TABLE `tmp_table_classifyid` (
  `id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of tmp_table_classifyid
-- ----------------------------

-- ----------------------------
-- Table structure for tmp_table_resource_classify
-- ----------------------------
DROP TABLE IF EXISTS `tmp_table_resource_classify`;
CREATE TABLE `tmp_table_resource_classify` (
  `id` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
-- Records of tmp_table_resource_classify
-- ----------------------------

-- ----------------------------
-- Procedure structure for createPeriod
-- ----------------------------
DROP PROCEDURE IF EXISTS `createPeriod`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `createPeriod`(IN period int(10))
    COMMENT '根据传入的分类，取得最近7天、1个月、1年的日期数据'
BEGIN 

DECLARE times int;

TRUNCATE table tmp_period;

set times = 7;
if period = 1 then
  set times = 7;
end if;
if period = 2 then
  set times = 30;
end if;
if period = 3 then
  set times = 12;
end if;
while times > 0 do
if period = 1 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(CURDATE(), INTERVAL times DAY), '%m-%d')); 
end if;
if period = 2 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(CURDATE(), INTERVAL times DAY), '%m-%d')); 
end if;
if period = 3 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(CURDATE(), INTERVAL times MONTH), '%Y-%m')); 
end if;
set times = times - 1;
end while;

select * from tmp_period;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for createPeriod1
-- ----------------------------
DROP PROCEDURE IF EXISTS `createPeriod1`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `createPeriod1`(IN `period` int(10), IN `selectDay` VARCHAR(50))
    COMMENT '根据传入的分类，取得最近7天、1个月、1年的日期数据'
BEGIN 

DECLARE times int;

TRUNCATE table tmp_period;

set times = 8;
if period = 0 then
  set times = 24;
end if;
if period = 1 then
  set times = 8;
end if;
if period = 2 then
  set times = 31;
end if;
if period = 3 then
  set times = 13;
end if;
while times >= 0 do
if period = 0 then
  insert into tmp_period(`period`) values (25 - times); 
end if;
if period = 1 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(selectDay, INTERVAL times DAY), '%m-%d')); 
end if;
if period = 2 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(selectDay, INTERVAL times DAY), '%Y-%m-%d')); 
end if;
if period = 3 then
  insert into tmp_period(`period`) values (date_format(DATE_SUB(selectDay, INTERVAL times MONTH), '%Y-%m')); 
end if;
set times = times - 1;
end while;

select * from tmp_period;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for findCourse_classifyChild
-- ----------------------------
DROP PROCEDURE IF EXISTS `findCourse_classifyChild`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `findCourse_classifyChild`(IN `iid` bigint)
BEGIN
TRUNCATE TABLE tmp_table_classifyid; 
SET@@max_sp_recursion_depth=10;
insert into tmp_table_classifyId values(iid);
call iterative(iid);

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for findResource_classifyChild
-- ----------------------------
DROP PROCEDURE IF EXISTS `findResource_classifyChild`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `findResource_classifyChild`(IN `iid` bigint)
BEGIN
TRUNCATE TABLE tmp_table_resource_classify; 
SET@@max_sp_recursion_depth=10;
insert into tmp_table_resource_classify values(iid);
call iterative_resource(iid);

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for iterative
-- ----------------------------
DROP PROCEDURE IF EXISTS `iterative`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `iterative`(IN `iid` bigint)
BEGIN
declare tid bigint(20) default -1;
declare cur1 CURSOR FOR select classifyId from mta_course_classify where upid=iid;
declare CONTINUE HANDLER FOR SQLSTATE '02000' SET tid = null;

OPEN cur1;
FETCH cur1 INTO tid;
WHILE(tid is not null)
DO
insert into tmp_table_classifyId values(tid);

call iterative(tid);
FETCH cur1 INTO tid;
END WHILE;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for iterative_resource
-- ----------------------------
DROP PROCEDURE IF EXISTS `iterative_resource`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `iterative_resource`(IN `iid` bigint)
BEGIN
declare tid bigint(20) default -1;
declare cur1 CURSOR FOR select classifyId from mta_resource_classify where upid=iid;
declare CONTINUE HANDLER FOR SQLSTATE '02000' SET tid = null;

OPEN cur1;
FETCH cur1 INTO tid;
WHILE(tid is not null)
DO
insert into tmp_table_resource_classify values(tid);

call iterative(tid);
FETCH cur1 INTO tid;
END WHILE;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for splitString
-- ----------------------------
DROP PROCEDURE IF EXISTS `splitString`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` PROCEDURE `splitString`(IN f_string varchar(1000),IN f_delimiter varchar(5))
BEGIN 
declare cnt int default 0; 
declare i int default 0; 
set cnt = func_get_splitStringTotal(f_string,f_delimiter); 
TRUNCATE TABLE tmp_split; 

while i < cnt 
do 
set i = i + 1; 
insert into tmp_split(`val_`) values (func_splitString(f_string,f_delimiter,i)); 
end while; 
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for func_getSplitString
-- ----------------------------
DROP FUNCTION IF EXISTS `func_getSplitString`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `func_getSplitString`(f_string varchar(1000),f_delimit varchar(5),f_order int) RETURNS varchar(255) CHARSET latin1
BEGIN  
  declare result varchar(255) default '';   
  set result = reverse(substring_index(reverse(substring_index(f_string,f_delimit,f_order)),f_delimit,1));   
  return result;   
end
;;
DELIMITER ;

-- ----------------------------
-- Function structure for func_get_splitStringTotal
-- ----------------------------
DROP FUNCTION IF EXISTS `func_get_splitStringTotal`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `func_get_splitStringTotal`(f_string varchar(10000),f_delimiter varchar(50)) RETURNS int(11)
BEGIN 
return 1+(length(f_string) - length(replace(f_string,f_delimiter,''))); 
END
;;
DELIMITER ;

-- ----------------------------
-- Function structure for func_splitString
-- ----------------------------
DROP FUNCTION IF EXISTS `func_splitString`;
DELIMITER ;;
CREATE DEFINER=`root`@`%` FUNCTION `func_splitString`(f_string varchar(1000),f_delimiter varchar(5),f_order int) RETURNS varchar(255) CHARSET latin1
BEGIN 

declare result varchar(255) default ''; 
set result = reverse(substring_index(reverse(substring_index(f_string,f_delimiter,f_order)),f_delimiter,1)); 
return result; 
END
;;
DELIMITER ;
